#ifndef LF_WIN_H
#define LF_WIN_H

typedef signed __int8 int8_t;
typedef signed __int16 int16_t;
typedef signed __int32 int32_t;
typedef signed __int64 int64_t;
typedef unsigned __int8 uint8_t;
typedef unsigned __int16 uint16_t;
typedef unsigned __int32 uint32_t;
typedef unsigned __int64 uint64_t;

#if defined _M_IX86
typedef signed __int32 intptr_t;
typedef unsigned __int32 uintptr_t;
#elif defined _M_IA64 || defined _M_AMD64
typedef signed __int64 intptr_t;
typedef unsigned __int64 uintptr_t;
#else
#error Unknown platform.
#endif

/**********************************************************************/
/* Sockets stuff                                                      */
/**********************************************************************/
#include <winsock2.h>
#include <windows.h>
#include <process.h>

typedef unsigned long in_addr_t;
typedef int socklen_t;

#define POLLIN   0x0001
#define POLLPRI  0x0002
#define POLLOUT  0x0004
#define POLLERR  0x0008
#define POLLHUP  0x0010
#define POLLNVAL 0x0020

struct pollfd {
  int fd;
  short events;
  short revents;
};

int poll(struct pollfd *ufds, unsigned int nfds, int timeout);

/**********************************************************************/
/* pthreads stuff                                                     */
/**********************************************************************/

/* pthread_t structure
 *
 * The start_routine prototype is different for pthread_create and
 * _beginthreadex so we need some extra state and a helper create
 * function to act as a shim.
 *
 * handle - _beginthread returns unsigned long but it really is a
 * HANDLE. This is important because that's what you do the
 * WaitForSingleObject on if you need to join. Remember to close the
 * handle when you're done.
 *
 * start_routine/arg - The helper uses these to translate the
 * _beginthreadex prototype to the pthread_create prototype.
 *
 * cancel - Flag in order to support pthread_cancel. Check at the
 * beginning of pthread functions.
 *
 * thread - Pointer to yourself. Some pthread functions take pthread_t,
 * _not_ pthread_t *. We may have to modify our state though. By having
 * the pointer to ourselves, we can do pass by reference even when we're
 * given pass by value. There is a limitation to this. You should use
 * pthread_t in one place and use pthread_t* from then on.
 *
 */
typedef struct pthread_t
{
  HANDLE handle;
  void *(*start_routine)(void*);
  void *arg;
  void *ret;
  int cancel;
  struct pthread_t *thread;
} pthread_t;

/* We don't support attributes but we need a type as a placeholder. */
typedef int pthread_attr_t;

typedef HANDLE pthread_mutex_t;
/* We don't support mutex attributes either. */
typedef int pthread_mutexattr_t;

#if 0
/* pthread_cond_t implementation ported from boost condition. Copyright
 * below. */

// Copyright (C) 2001-2003
// William E. Kempf
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without fee,
// provided that the above copyright notice appear in all copies and
// that both that copyright notice and this permission notice appear
// in supporting documentation.  William E. Kempf makes no representations
// about the suitability of this software for any purpose.
// It is provided "as is" without express or implied warranty.

typedef struct pthread_cond_t
{
    void* m_gate;
    void* m_queue;
    void* m_mutex;
    unsigned m_gone;  // # threads that timed out and never made it to m_queue
    unsigned long m_blocked; // # threads blocked on the condition
    unsigned m_waiting; // # threads no longer waiting for the condition but
                        // still waiting to be removed from m_queue
} pthread_cond_t;
/* No cv attributes. */
typedef int pthread_condattr_t;
#endif

typedef DWORD pthread_key_t;

static int pthread_canceled;
#define PTHREAD_CANCELED &pthread_canceled
/*{{{ Thread Routines */
int pthread_create(pthread_t *thread, const pthread_attr_t *attr,
		   void *(*start_routine)(void *), void *arg);
int pthread_cancel(pthread_t thread);
int pthread_detach(pthread_t thread);
int pthread_equal(pthread_t t1, pthread_t t2);
void pthread_exit(void *value_ptr);
int pthread_join(pthread_t thread, void **value_ptr);
#if 0
int pthread_kill(pthread_t thread, int sig);
int pthread_once(pthread_once_t *once_control, void
		 (*init_routine)(void));
#endif
pthread_t pthread_self(void);
#if 0
int pthread_setcancelstate(int state, int *oldstate);
int pthread_setcanceltype(int type, int *oldtype);
#endif
void pthread_testcancel(void);
void pthread_yield(void);
/*}}}*/
/*{{{ Attribute Object Routines */
#if 0
int pthread_attr_destroy(pthread_attr_t *attr);
int pthread_attr_getinheritsched(const pthread_attr_t *attr,
				 int *inheritsched);
int pthread_attr_getschedparam(const pthread_attr_t *attr,
			       struct sched_param *param);
int pthread_attr_getschedpolicy(const pthread_attr_t *attr,
				int *policy);
int pthread_attr_getscope(const pthread_attr_t *attr,
			  int *contentionscope);
int pthread_attr_getstacksize(const pthread_attr_t *attr,
			      size_t *stacksize);
int pthread_attr_getstackaddr(const pthread_attr_t *attr,
			      void **stackaddr);
int pthread_attr_getdetachstate(const pthread_attr_t *attr,
				int *detachstate);
int pthread_attr_init(pthread_attr_t *attr);
int pthread_attr_setinheritsched(pthread_attr_t *attr,
				 int inheritsched);
int pthread_attr_setschedparam(pthread_attr_t *attr,
			       const struct sched_param *param);
int pthread_attr_setschedpolicy(pthread_attr_t *attr, int policy);
int pthread_attr_setscope(pthread_attr_t *attr, int contentionscope);
int pthread_attr_setstacksize(pthread_attr_t *attr, size_t stacksize);
int pthread_attr_setstackaddr(pthread_attr_t *attr, void *stackaddr);
int pthread_attr_setdetachstate(pthread_attr_t *attr, int detachstate);
#endif
/*}}}*/
/*{{{ Mutex Routines */
#if 0
int pthread_mutexattr_destroy(pthread_mutexattr_t *attr);
int pthread_mutexattr_getprioceiling(pthread_mutexattr_t *attr,
				     int *ceiling);
int pthread_mutexattr_getprotocol(pthread_mutexattr_t *attr,
				  int *protocol);
int pthread_mutexattr_gettype(pthread_mutexattr_t *attr, int *type);
int pthread_mutexattr_init(pthread_mutexattr_t *attr);
int pthread_mutexattr_setprioceiling(pthread_mutexattr_t *attr,
				     int ceiling);
int pthread_mutexattr_setprotocol(pthread_mutexattr_t *attr,
				  int protocol);
int pthread_mutexattr_settype(pthread_mutexattr_t *attr, int type);
#endif
int pthread_mutex_destroy(pthread_mutex_t *mutex);
int pthread_mutex_init(pthread_mutex_t *mutex,
		       const pthread_mutexattr_t *attr);
int pthread_mutex_lock(pthread_mutex_t *mutex);
#if 0
int pthread_mutex_timedlock(pthread_mutex_t *mutex,
			    const struct timespec *abstime);
int pthread_mutex_trylock(pthread_mutex_t *mutex);
#endif
int pthread_mutex_unlock(pthread_mutex_t *mutex);
/*}}}*/
/*{{{ Condition Variable Routines */
#if 0
int pthread_condattr_destroy(pthread_condattr_t *attr);
int pthread_condattr_init(pthread_condattr_t *attr);
#endif
#if 0
int pthread_cond_broadcast(pthread_cond_t *cond);
int pthread_cond_destroy(pthread_cond_t *cond);
int pthread_cond_init(pthread_cond_t *cond,
		      const pthread_condattr_t *attr);
int pthread_cond_signal(pthread_cond_t *cond);
#endif
#if 0
int pthread_cond_timedwait(pthread_cond_t *cond, pthread_mutex_t *mutex,
			   const struct timespec *abstime);
#endif
#if 0
int pthread_cond_wait(pthread_cond_t *cond, pthread_mutex_t *mutex);
#endif
/*}}}*/
/*{{{ Read/Write Lock Routines */
#if 0
int pthread_rwlock_destroy(pthread_rwlock_t *lock);
int pthread_rwlock_init(pthread_rwlock_t *lock,
			const pthread_rwlockattr_t *attr);
int pthread_rwlock_rdlock(pthread_rwlock_t *lock);
int pthread_rwlock_tryrdlock(pthread_rwlock_t *lock);
int pthread_rwlock_trywrlock(pthread_rwlock_t *lock);
int pthread_rwlock_unlock(pthread_rwlock_t *lock);
int pthread_rwlock_wrlock(pthread_rwlock_t *lock);
int pthread_rwlockattr_destroy(pthread_rwlockattr_t *attr);
int pthread_rwlockattr_getpshared(const pthread_rwlockattr_t *attr,
				  int *pshared);
int pthread_rwlockattr_init(pthread_rwlockattr_t *attr);
int pthread_rwlockattr_setpshared(pthread_rwlockattr_t *attr,
				  int pshared);
#endif
/*}}}*/
/*{{{ Per-Thread Context Routines */
int pthread_key_create(pthread_key_t *key, void (*routine)(void *));
int pthread_key_delete(pthread_key_t key);
void *pthread_getspecific(pthread_key_t key);
int pthread_setspecific(pthread_key_t key, const void *value_ptr);
/*}}}*/
/*{{{ Cleanup Routines */
#if 0
void pthread_cleanup_pop(int execute);
void pthread_cleanup_push(void (*routine)(void *), void *routine_arg);
#endif
/*}}}*/

#endif
